
tmpFile = "MwAttachmentBundle.UIDS"

Sub Main()
	DBWInit(True)
	'DBWMsgbox("here")
	'Exit Sub

	'Get selected docs
	Call DBWShell("GetSelection")
	
	If Not (okDBW) Then
		DBWMsgbox("Unable to get selection.  Please try again.")
		Exit Sub
	End If
	
	docUids = DBWResult("@SELECTION")
	
	
	If docUids = "" or docUids = "0" Then
		DBWMsgbox("Unable to get selection.  Please try again.")
		Exit Sub
	End If
	
	ok = WriteUids(docUids)
	
	If Not ok Then
		DBWMsgbox("Projects and drawings not allowed.  Please select an assembly and try again.")
		Exit Sub
	End If

	'DBWMsgbox("about to execute tool")
	
	Call ExeTool()
	
End Sub

Function WriteUids(uids)
	WriteUids = False
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set tFolder = fso.GetSpecialFolder(2)
	If Right(tFolder, 1) <> "\" Then
		tFolder = tFolder & "\"
	End If
	
	Set objFile = fso.OpenTextFile(tFolder & tmpFile, 2, True)
	arrUids = Split(uids, ",")
	
	For Each uid In arrUids
		If UidOk(uid) Then
			WriteUids = True
			objFile.WriteLine(uid)
		End If
	Next
	
	objFile.Close()
	Set objFile = Nothing
	Set tFolder = Nothing
	Set fso = Nothing
	
End Function

Function UidOk(uid)
	UidOk = True
	tField = DBWLookUp("NAME_FIELD_T")
	tVal = DBWQueryByUid(uid, tField)
	If tVal = "0" or tVal = "D" Then
		UidOk = False
	End If
End Function

Sub ExeTool()
	lstDir = DBWGetOption("LST_DIR")
	If Right(lstDir, 1) <> "\" Then
		lstDir = lstDir & "\"
	End If
	
	
	toolFile = lstDir & "AttachmentBundle\AttachmentBundle.exe"

	'DBWMsgbox(toolFile)
	
	Set objShell = CreateObject("WScript.Shell")
	Call objShell.Run(Chr(34) & toolFile & Chr(34))
	Set objShell = Nothing
End Sub

